const CONSTANTS = {
    ACTIONS: {
        ADD_LOG_MENU: 'add_log_menu',
        BACK_TO_HINT: 'back_to_hint',
        BLOCK_UI: 'block_ui',
        CHECK_IS_FRAME: 'check_is_frame',
        CHECK_IS_FRAMESET: 'check_is_frameset',
        CLOSE_DIALOG: 'close_dialog',
        CLOSE_NOTIFICATION: 'close_notification',
        CLOSE_WELCOME_DIALOG: 'close_welcome_dialog',
        ELEMENT_CAPTURED: 'element_captured',
        GENERATE_XPATH: 'generate_xpath',
        GENERATION_FINISHED: 'generation_finished',
        GET_PRECISE_XPATH_FOR_FRAME: 'get_precise_xpath_for_frame',
        HIDE_DIALOG: 'hide_dialog',
        HINT_DIALOG_RESULT: 'hint_dialog_result',
        LOCATOR_DIALOG_RESULT: 'locator_dialog_result',
        OPEN_DIALOG: 'open_dialog',
        REMOVE_LOG_MENU: 'remove_log_menu',
        RESET_CAPTURING: 'reset_capturing',
        SEND_NOTIFICATION_MESSAGE: 'send_notification_message',
        SEND_CHROME_NOTIFICATION: 'send_chrome_notification',
        SEND_LOG_INFO: 'send_log_info',
        SHOW_ALERT: 'show_alert',
        SHOW_DIALOG: 'show_dialog',
        SHOW_NOTIFICATION: 'show_notification',
        SKIP: 'skip',
        START_CAPTURING: 'start_capturing',
        STOP_CAPTURING: 'stop_capturing',
        SYNC_DIALOG_SIZE: 'sync_dialog_size',
        SYNC_NOTIFICATION_SIZE: 'sync_notification_size',
        TEST: 'test',
        TEST_CSS: 'test_css',
        TEST_CSS_FINISHED: 'test_css_finished',
        TEST_XPATH: 'test_xpath',
        TEST_XPATH_FINISHED: 'test_xpath_finished',
    },
    ALGORITHM_TYPES: {
        ABSOLUTE_XPATH: 'Absolute XPath',
        SMART_XPATH: 'Smart XPath algorithm',
        TEMPLATES: 'XPath Templates',
    },
    ATTRIBUTES: {
        CLASS: 'class',
        ID: 'id',
        NAME: 'name',
        SRC: 'src',
        STYLE: 'style',
        OUTLINE: 'outline',
        READONLY: 'readonly',
        SANDBOX: 'sandbox',
        TITLE: 'title',
        DATA: 'data-',
        DATA2: 'data_',
        ONMOUSELEAVE: 'onmouseleave',
        ONMOUSEENTER: 'onmouseenter',
        SCOPE: 'scope',
    },
    ATTRIBUTE_SRC_VALUE_SRCDOC: 'about:srcdoc',
    CLICKABLE_ELEMENT_TAGS: [
        'a',
        'input',
        'button'
    ],
    CSS: {
        SHADOW_PSEUDO: '::shadow',
    },
    CSS_HELPERS: {
        NTH_CHILD_FULL: '${CSS} > ${NAME}:nth-child(${VALUE})',
        NTH_OF_TYPE: ':nth-of-type(${VALUE})',
        NTH_PATTERN: ':nth-of-type\\((\\d+)\\)',
        CSS_SELECTOR_1: '${CSS}[${NAME}="${VALUE}"]',
        CSS_SELECTOR_2: '${CSS}[${NAME}=\'${VALUE}\']',
    },
    DIALOG_ELEMENTS: {
        CLOSE_CONTAINER: {
            LABEL: 'CloseContainer',
        },
        CLOSE_BUTTON: {
            LABEL: 'CloseButton',
        },
        HANDLE: {
            LABEL: 'Handle',
        },
        IFRAME: {
            LABEL: 'Frame',
        }
    },
    DIALOG_FRAME_OPTIONS: {
        HINT: {
            TYPE: 'Hint',
            CLASS_NAME: 's7-hint',
            URL: '/js/frames/hint/hint.html',
            WIDTH: 400
        },
        LOCATOR: {
            TYPE: 'Locator',
            CLASS_NAME: 's7-locator',
            URL: '/js/frames/locator/locator.html',
            WIDTH: 705
        }
    },
    DIALOG_OPTIONS: {
        HINT: {
            URL: '/js/dialogs/hint/hint.html',
            WIDTH: 400,
            HEIGHT: 215,
            ADVANCED_HEIGHT: 355
        },
        LOCATOR: {
            URL: '/js/dialogs/locator/locator.html',
            WIDTH: 705,
            HEIGHT: 295,
            ADVANCED_HEIGHT: 435
        },
        WELCOME: {
            URL: 'js/dialogs/welcome/welcome.html',
            WIDTH: 375,
            HEIGHT: 180
        },
    },
    DRAGGABLE_OPTIONS: {
        handle: '.handle',
        cursor: 'move',
        delay: 100,
        distance: 1,
        opacity: 0.7,
        addClass: false,
        iframeFix: true,
        containment: 'window',
        scroll: false
    },
    ERROR_MESSAGES: {
        CSS_CAN_NOT_BE_GENERATED: 'CSS Selector could not be generated',
        CSS_RETURNS_SEVERAL_ELEMENTS: 'CSS returns several elements',
        CSS_SELECTOR_GENERATION_ERROR: '[CSS_SELECTOR_GENERATION] ',
        CUSTOM_CSS_SELECTOR_WILL_BE_GENERATED: 'The target element is inside the Shadow DOM, a custom CSS Selector will be generated instead of XPath',
        ELEMENT_NOT_FOUND_CSS: 'No element was found with the provided CSS Selector',
        ELEMENT_NOT_FOUND_XPATH: 'No element was found with the provided XPath',
        INVALID_CSS: 'Error while testing CSS Selector: ',
        INVALID_OR_UNSUPPORTED_XPATH: '[CSS_SELECTOR_GENERATION] Cannot generate CSS Selector from XPath: Invalid or unsupported XPath ',
        INVALID_OR_UNSUPPORTED_XPATH_ATTRIBUTE: '[CSS_SELECTOR_GENERATION] Cannot generate CSS Selector from XPath: Invalid or unsupported XPath attribute ',
        INVALID_XPATH: 'Invalid XPath',
        MISSING_XPATH_EXPRESSION: '[CSS_SELECTOR_GENERATION] Cannot generate CSS Selector from XPath: Missing XPath expression',
        SHADOW_CSS_CANNOT_END_ON_A_SHADOW_ROOT: 'A Shadow DOM CSS selector cannot end on a shadow root element. Please end the selector with an element inside the shadow root',
        UNABLE_TO_GENERATE_XPATH_FOR_FRAME: 'XPath could not be generated for frame',
        XPATH_AND_CSS_CAN_NOT_BE_GENERATED: 'The target element is inside a closed shadow DOM, neither the CSS selector nor the XPath will be generated',
        XPATH_RETURNS_SEVERAL_ELEMENTS: 'XPath returns several elements',
        NO_MATCHING_TEMPLATE: 'No matching template found',
        MISSING_PATTERNS: 'Missing templates',
        ERROR_FETCHING_TARGET_ELEMENT_BY_XPATH: 'Target element could not be found with provided XPath',
    },
    EVENTS: {
        LOCAL_PLAYER: {
            EVENT_GUTENBERG_CONNECTION_RESPONSE: 'EVENT_GUTENBERG_CONNECTION_RESPONSE',
        },
        DOM: {
            CLICK: 'click',
            INPUT: 'input',
            KEY_DOWN: 'keydown',
            KEY_UP: 'keyup',
            SUBMIT: 'submit',
            BLUR: 'blur',
        },
        WINDOW: {
            MESSAGE: 'message',
            DOM_CONTENT_LOADED: 'DOMContentLoaded',
        },
    },
    EXTENSION_NAME: 'Subject7 Gutenberg',
    EXTERNAL_EXTENSIONS: {
        RECORDER: {
            ID: 'ccjpbnplcmmlkogjfpamhdpjhamhckac',
            ID_FROM_STORE: 'ajdomjioajflpgeppddeonfgnpjefinl',
            REASON: 'checkStatus',
        },
    },
    FRAMES: {
        SUCCESS_TOAST: {
            URL: '/js/frames/toasts/successToast.html',
            DELAY: 2000
        },
        ERROR_TOAST: {
            URL: '/js/frames/toasts/errorToast.html',
            DELAY: 5000
        },
    },
    HINT: {
        ATTRIBUTES_LIST: [
            'value',
            'placeholder',
            'name',
            'title',
            'for'
        ]
    },
    ID_RULES: {
        CONTAINS_RESTRICTED_CHARACTERS: '[^-^:^_^a-z^A-Z^0-9]',
        ENDS_WITH_COLON_AND_NUMBER: ':\\d+$',
        ENDS_WITH_NUMBER: '\\d+$',
        STARTS_WITH_NUMBER: '^\\d',
        STARTS_WITH_HYPHEN_AND_NUMBER: '^-\\d',
    },
    KEEP_ALIVE_CHECK_TIMEOUT: 29e3,
    LOG_INFO: {
        PORT: 'LOG_INFO_PORT',
        URL: 'js/logInfo/logInfo.html',
        MENU_ID: 'openLogInfoPopup',
        MENU_TITLE: 'Open Matching XPath Templates Information Log',
        WIDTH: 1280,
        HEIGHT: 800,
    },
    MESSAGE_SENDERS: {
        CHILD_WINDOW: 'subject7-gutenberg-child-window',
        S7_OPEN_HINT_WINDOW: 'subject7-gutenberg-open-hint-window',
        S7_OPEN_LOCATOR_WINDOW: 'subject7-gutenberg-open-locator-window',
        S7_NOTIFICATION: 'subject7-gutenberg-notification',
    },
    MESSAGING_PORT: 'GUTENBERG_CS2SW',
    NAMESPACE_URI_DEFAULT: 'http://www.w3.org/1999/xhtml',
    NOTIFICATION_MESSAGES: {
        CONFIGURATION_SAVED: 'Configuration is saved',
        LOCATOR_SAVED: 'Locator is saved',
        FAILED_TO_FETCH: 'Failed to fetch',
        REFRESH_PAGE: 'Please browse to a URL or refresh current page',
        SETTINGS_NOT_FOUND: 'No settings were found for Gutenberg',
        CONNECTION_TEST_SUCCESSFUL: 'Connection test successful',
        CANNOT_ENABLE_GUTENBERG: 'Cannot enable Gutenberg because Recorder is active',
        GUTENBERG_IS_INACTIVE: 'Gutenberg is inactive because Recorder is active',
        UNEXPECTED_RESPONSE: 'You have got unexpected response from server. Please contact administrator\nResponse code: $STATUS\nResponse body: $DATA',
        WRONG_CREDENTIALS: 'Wrong credentials. Please check username and password',
        WRONG_CREDENTIALS_API_KEY: 'Wrong credentials. Please check API key',
        SOMETHING_WENT_WRONG: 'Something went wrong.\nPlease check Subject7 host on a settings page.\nThen check did you allowed the plugin read and change site data.\n1. Right-click on the plugin icon.\n2. This can read and change site data.\n3. Select \'On all sites\'.\nAlso please verify Network.\nIf it doesn\'t help, please contact the administrator',
        UNEXPECTED_ERROR: 'Unexpected error',
        ERROR_EXECUTING_REQUEST: 'Error while executing request: $ERROR',
        XPATH_TEMPLATES_RECEIVED: 'XPath Templates have been received',
    },
    NOTIFICATION_ID: 'GUTENBERG_S7_NOTIFICATION',
    NOTIFICATION_ICON_URL: '/img/app-icon128x128.png',
    NOTIFICATION_TYPES: {
        ERROR: 'ERROR',
        SUCCESS: 'SUCCESS',
    },
    OPEN_DIALOG_DELAY: {
        HINT: 200,
        LOCATOR: 200
    },
    REPLACE_STRINGS: {
        CSS: '${CSS}',
        NAME: '${NAME}',
        VALUE: '${VALUE}',
    },
    REQUEST_METHODS: {
        GET: 'GET',
        POST: 'POST',
    },
    REQUEST_PATHS: {
        HEALTH_CHECK: '/api/v2/health-check',
        LOCATORS: '/api/v1/locators',
        XPATH_TEMPLATES: '/api/v1/xpath_templates',
    },
    SHADOW_MODES: {
        OPEN: 'open',
        CLOSED: 'closed',
    },
    TAGS: {
        HTML: 'html',
        BODY: 'body',
        DIV: 'div',
        DOCUMENT_FRAGMENT: '#document-fragment',
        IFRAME: 'iframe',
        LABEL: 'label',
        RECORDER_BLOCK: 'recorderblock',
        FRAMESET: 'FRAMESET',
        TOAST_BLOCK: 'toastblock',
        BUTTON: 'button',
        TABLE: 'table',
        THEAD: 'thead',
        TBODY: 'tbody',
        TH: 'th',
        TR: 'tr',
        TD: 'td',
    },
    TEST_TYPES: {
        CSS: 'CSS',
        XPATH: 'XPath',
    },
    TOKENS: {
        TYPE: 'type',
        PSEUDO_ELEMENT: 'pseudo-element',
        PSEUDO_CLASS: 'pseudo-class',
        CLASS: 'class',
        ATTRIBUTE: 'attribute',
        ID: 'id',
        COMBINATOR: 'combinator',
    },
    TOKEN_SIGNATURES: {
        attribute: /\[\s*(?:(?<namespace>\*|[-\w\P{ASCII}]*)\|)?(?<name>[-\w\P{ASCII}]+)\s*(?:(?<operator>\W?=)\s*(?<value>.+?)\s*(\s(?<caseSensitive>[iIsS]))?\s*)?\]/gu,
        id: /#(?<name>[-\w\P{ASCII}]+)/gu,
        class: /\.(?<name>[-\w\P{ASCII}]+)/gu,
        comma: /\s*,\s*/g,
        combinator: /\s*[\s>+~]\s*/g,
        'pseudo-element': /::(?<name>[-\w\P{ASCII}]+)(?:\((?<argument>¶*)\))?/gu,
        'pseudo-class': /:(?<name>[-\w\P{ASCII}]+)(?:\((?<argument>¶*)\))?/gu,
        universal: /(?:(?<namespace>\*|[-\w\P{ASCII}]*)\|)?\*/gu,
        type: /(?:(?<namespace>\*|[-\w\P{ASCII}]*)\|)?(?<name>[-\w\P{ASCII}]+)/gu
    },
    WARNING_MESSAGES: {
        ABSOLUTE_XPATH_CREATED: 'We could not create an XPath using Smart XPath, and instead created an absolute XPath. You can go back and increase the distance in the Advanced settings to improve the chance of utilizing Smart XPath',
    },
    VISIBILITY: {
        HIDDEN: 'hidden',
        VISIBLE: 'visible',
    },
    XPATH_HELPERS: {
        START_XPATH: '//',
        NODE_DIVIDER: '/',
        BRACKETS_PATTERN: '[${VALUE}]',
    }
};
